def rangetest(*argchecks):                  # Sprawdzenie przedziałów argumentów pozycyjnych
    def onDecorator(func):
        if not __debug__:                   # True, jeśli "python –O main.py args..."
            return func                     # Nie działa: bezpośrednie wywołanie oryginału
        else:                               # Inaczej opakowanie w czasie debugowania
            def onCall(*args):
                for (ix, low, high) in argchecks:
                    if args[ix] < low or args[ix] > high:
                        errmsg = f'Argument {ix} nie mieści się w przedziale {low}..{high}'
                        raise TypeError(errmsg)
                return func(*args)
            return onCall
    return onDecorator

