class Person:
    def __init__(self, name, job=None, pay=0):
        self.name = name
        self.job  = job
        self.pay  = pay
    def lastName(self):
        return self.name.split()[-1]
    def giveRaise(self, percent):
        self.pay = int(self.pay * (1 + percent))
    def __repr__(self):
        return f'[Person: {self.name} ${self.pay:,}]'

class Manager(Person):
    def giveRaise(self, percent, bonus=.10):           # Redefiniowanie na tym poziomie
        Person.giveRaise(self, percent + bonus)        # Wywołanie wersji klasy Person

if __name__ == '__main__':
    bob = Person('Robert Zielony')
    anna = Person('Anna Czerwona', job='programista', pay=100000)
    print(bob)
    print(anna)
    print(bob.lastName(), anna.lastName())
    anna.giveRaise(.10)
    print(anna)
    tom = Manager('Tomasz Czarny', 'manager', 50000)   # Utworzenie obiektu Manager: __init__
    tom.giveRaise(.10)                                 # Wykonanie własnej wersji
    print(tom.lastName())                              # Wykonanie odziedziczonej metody
    print(tom)                                         # Wykonanie odziedziczonej __repr__

    # TYMCZASOWY KOD
    print('--Wszystkie trzy--')
    for obj in (bob, anna, tom):              # Ogólne przetwarzanie obiektów
        obj.giveRaise(.10)                    # Wykonanie metody giveRaise tego obiektu
        print(obj)                            # Wykonanie wspólnej metody __str__

