from person_10 import Person                        # Przykład 28.10.

class Manager:
    def __init__(self, name, pay):
        self.person = Person(name, 'mgr', pay)      # Osadzenie obiektu Person

    def giveRaise(self, percent, bonus=.10):
        self.person.giveRaise(percent + bonus)      # Przechwycenie i delegowanie

    def __getattr__(self, attr):
        return getattr(self.person, attr)           # Delegowanie wszystkich pozostałych atrybutów

    def __repr__(self):
        return str(self.person)                     # Musi znowu przeciążać operator

if __name__ == '__main__':
    tom = Manager('Tomasz Czarny', 50000)           # Osadzenie obiektu Person
    tom.giveRaise(.10)                              # Uruchomienie Manager.giveRaise
    print(tom.lastName())                           # Delegowanie do osadzonego obiektu
    print(tom)                                      # Uruchomienie Manager.__repr__

