"""
Podobnie do poprzedniego przykładu, ale wykorzystuje klasy, tak by każde okno 
miało własne informacje o stanie.
Uwaga! Ten graficzny interfejs użytkownika może się powiększać,
dopóki nie naciśniesz Stop lub nie zamkniesz okna!
"""

from tkinter import *
import random

class MyGui:
    """
    Graficzny interfejs użytkownika z przyciskami zmieniającymi kolor i powiększającymi napis
    """
    colors = ['blue', 'green', 'orange', 'red', 'brown', 'yellow']

    def __init__(self, parent, title='popup'):
        parent.title(title)
        self.growing = False
        self.fontsize = 10
        self.lab = Label(parent, text='Hakować2', fg='white', bg='navy')
        self.lab.pack(expand=YES, fill=BOTH)
        Button(parent, text='Hakować', command=self.reply).pack(side=LEFT)
        Button(parent, text='Powiększ', command=self.grow).pack(side=LEFT)
        Button(parent, text='Stop', command=self.stop).pack(side=LEFT)

    def reply(self):
        "losowa modyfikacja koloru przycisku po naciśnięciu przycisku Hakować"
        self.fontsize += 5
        color = random.choice(self.colors)
        self.lab.config(bg=color,
                font=('courier', self.fontsize, 'bold italic'))

    def grow(self):
        "po naciśnięciu przycisku Powiększ podpis zaczyna rosnąć"
        self.growing = True
        self.grower()

    def grower(self):
        "wielokrotne przyciśnięcia powodują kolejkowanie zwiększania się rozmiaru podpisu"
        if self.growing:
            self.fontsize += 5
            self.lab.config(font=('courier', self.fontsize, 'bold'))
            self.lab.after(500, self.grower)

    def stop(self):
        "po naciśnięciu przycisku Stop przycisk przestaje rosnąć"
        self.growing = False

class MySubGui(MyGui):
    colors = ['black', 'purple']           # Można dostosować w celu modyfikacji kolorów do wyboru

MyGui(Tk(), 'main')
MyGui(Toplevel())
MySubGui(Toplevel())
mainloop()

