"""
Utworzenie graficznego interfejsu użytkownika za pomocą tkinter
z przyciskami zmieniającymi kolor oraz wielkość.
Uwaga! Ten graficzny interfejs użytkownika może się powiększać,
dopóki nie zamkniesz jego okna ręcznie!
"""

from tkinter import *
import random
fontsize = 25
colors = ['red', 'green', 'blue', 'yellow', 'orange', 'white', 'cyan', 'purple']

def reply(text):
    print(text)
    popup = Toplevel()
    color = random.choice(colors)
    Label(popup, text='Okno wyskakujące', bg='black', fg=color).pack()
    L.config(fg=color)

def cycle():
    L.config(fg=random.choice(colors))
    win.after(250, cycle)

def grow():
    global fontsize
    fontsize += 5
    L.config(font=('arial', fontsize, 'italic'))
    win.after(100, grow)

win = Tk()
L = Label(win, text='Hakować',
          font=('arial', fontsize, 'italic'), fg='yellow', bg='navy',
          relief=RAISED)
L.pack(side=TOP, expand=YES, fill=BOTH)
Button(win, text='Naciśnij', command=(lambda: reply('new'))).pack(side=BOTTOM, fill=X)
Button(win, text='Licznik', command=cycle).pack(side=BOTTOM, fill=X)
Button(win, text='Powiększ', command=grow).pack(side=BOTTOM, fill=X)
win.mainloop()

