"Rozszerzenie klasy z metaklasą"

def triple(obj):
    return obj.value * 3                                  # Funkcje do wstawienia
                                                          # Metody, jeśli nie w klasie
def concat(obj):                                          # Gdzie "obj" to "self"
    return obj.value + 'Kod!'

class Extender(type):
    def __new__(meta, classname, supers, classdict):      # W momencie tworzenia klasy klienta
        classdict['triple'] = triple                      # Dodanie funkcji jako atrybutów
        classdict['concat'] = concat
        return type.__new__(meta, classname, supers, classdict)

class Client1(metaclass=Extender):
    def __init__(self, value):                            # Utworzony z Extender
        self.value = value                                # Własne + wstawione metody
    def double(self):
        return self.value * 2

class Client2(metaclass=Extender):                        # Utworzony z Extender
    value = 'grok'                                        # Odziedziczone dane klasy

X = Client1('hakować')                                       
print(X.double(), X.triple(), X.concat(), sep='\n')

Y = Client2()                                             
print(Y.triple(), Y.concat(), sep='\n')

