# (Niezawarte w książce) To samo co employee.py, ale z wykorzystaniem funkcji super() zamiast wywołań konstruktorów poprzez podanie nazwy klasy

class Employee:
    def __init__(self, name, salary=0):
        self.name   = name
        self.salary = salary
    def giveRaise(self, percent):
        self.salary += self.salary * percent
    def work(self):
        print(self.name, 'does stuff')
    def __repr__(self):
        return (f'<{self.__class__.__name__}: '
                f'name="{self.name}", salary={self.salary:,.2f}>')

class Chef(Employee):
    def __init__(self, name):
        super().__init__(name, 50000)
    def work(self):
        print(self.name, 'przygotowuje jedzenie')

class Server(Employee):
    def __init__(self, name):
        super().__init__(name, 40000)
    def work(self):
        print(self.name, 'obsługuje klienta')

class PizzaRobot(Chef):
    def __init__(self, name):
        super().__init__(name)
    def work(self):
        print(self.name, 'robi pizzę')

if __name__ == '__main__':
    bob = PizzaRobot('Robert')    # Tworzy robota o imieniu Robert
    print(bob)                    # Wykonuje odziedziczoną metodę __repr__
    bob.work()                    # Wykonuje działanie specyficzne dla typu
    bob.giveRaise(0.20)           # Daje robotowi 20-procentową podwyżkę
    print(bob); print()

    for klass in Employee, Chef, Server, PizzaRobot:
        object = klass(klass.__name__)
        object.work()

