import time

def tracer(func):                         # Użycie funkcji, a nie klasy z __call__
    calls = 0                             # Inaczej self będzie jedynie instancją dekoratora
    def onCall(*args, **kwargs):
        nonlocal calls
        calls += 1
        print(f'wywołanie {calls} to {func.__name__}')
        return func(*args, **kwargs)
    return onCall

def timer(label='', trace=True):                # Dla argumentów dekoratora — zachowanie argumentów
    def onDecorator(func):                      # Dla @ — zachowanie udekorowanej funkcji
        def onCall(*args, **kargs):             # W momencie wywołania — wywołanie oryginału
            start   = time.perf_counter()       # Stan to zakresy + atrybuty funkcji
            result  = func(*args, **kargs)
            elapsed = time.perf_counter() - start
            onCall.alltime += elapsed
            if trace:
                funcname, alltime = func.__name__, onCall.alltime
                print(f'{label}{funcname}: {elapsed:.5f}, {alltime:.5f}')
            return result
        onCall.alltime = 0
        return onCall
    return onDecorator

