def tracer(func):                      # Zapamiętanie oryginalnej wartości
    def oncall(*args):                 # dla późniejszych wywołań
        oncall.calls += 1
        print(f'wywołanie {oncall.calls} to {func.__name__}')
        return func(*args)
    oncall.calls = 0
    return oncall

class C:
    @tracer
    def hack(self, a, b, c): return a + b + c

if __name__ == '__main__':
    x = C()
    print(x.hack(1, 2, 3))
    print(x.hack('a', 'b', 'c'))         

