class Super:
    def method(self):
        print('w Super.method')             # Zachowanie domyślne
    def delegate(self):
        self.action()                        # Oczekuje zdefiniowania

class Inheritor(Super):                      # Odziedziczenie wszystkich metod
    pass

class Replacer(Super):                       # Całkowite zastąpienie metody def method(self):
    def method(self):
        print('w Replacer.method')

class Extender(Super):                       # Rozszerzenie działania metody def method(self):
    def method(self):
        print('początek Extender.method')
        Super.method(self)                   # Albo super().method()
        print('koniec Extender.method')

class Provider(Super):                       # FUzupełnienie wymaganej metody
    def action(self):
        print('w Provider.action')

if __name__ == '__main__':
    for klass in (Inheritor, Replacer, Extender):
        print('\n' + klass.__name__ + '...')
        klass().method()

    print('\nProvider...')
    x = Provider()
    x.delegate()

