from mylist import MyList

class MyListSub(MyList):
    calls = 0                                      # Współdzielona przez instancje
    def __init__(self, start):
        self.adds = 0                              # Różni się w każdej instancji
        MyList.__init__(self, start)               # Lub super().__init__(start)

    def __add__(self, other):
        print('add: ' + str(other))
        MyListSub.calls += 1                       # Licznik dla całej klasy
        self.adds += 1                             # Liczniki dla instancji
        return MyList.__add__(self, other)         # Lub super().__add__(other)

    def stats(self):
        return self.calls, self.adds               # Wszystkie dodawania, moje dodawania

if __name__ == '__main__':
    x = MyListSub('czytać')
    y = MyListSub('kod')
    print(x[2])
    print(x[1:])
    print(x + ['pw6w'])
    print(x + ['książka'])
    print(y + ['py312'])
    print(x.stats())

