from setwrapper import Set

class MultiSet(Set):
    """
   Dziedziczy wszystkie zmienne klasy Set, jednak
   rozszerza intersect oraz union w taki sposób, by
   obsługiwały większą liczbę argumentów. Warto
   zauważyć, że "self" nadal jest pierwszym
   argumentem (przechowanym teraz w argumencie *args).
   Odziedziczone operatory & oraz | wywołują nowe
   metody z dwoma argumentami, jednak przetworzenie
   więcej niż dwóch wymaga wywołania metody, a nie
   wyrażenia. Metoda intersect nie usuwa duplikatów —
   robi to konstruktor Set.
    """
    def intersect(self, *others):
        res = []
        for x in self:                         # Przeszukanie pierwszej sekwencji
            for other in others:               # Dla wszystkich pozostałych argumentów
                if x not in other: break       # Element w każdym z nich?
            else:                              # Nie — wyjście z pętli
                res.append(x)                  # Tak — dodanie elementu na końcu
        return Set(res)

    def union(*args):                          # self to args[0]
        res = []
        for seq in args:                       # Dla wszystkich argumentów
            for x in seq:                      # Dla wszystkich węzłów
                if not x in res:
                    res.append(x)              # Dodanie nowych elementów do wyniku
        return Set(res)

