# Sumowanie z ksiązki i dodatkowy kod

more = lambda x: None
note = lambda q, x: print(x, end=', ') if q else None
from sumtree_tester import tester



# Breadth-first by items: add to end

def sumtree(L, trace=False):                     # Najpierw wszerz, jawna kolejka
    tot = 0
    items = list(L)                              # Rozpoczęcie od kopi na najwyższym poziomie    
    while items:
        more(items)
        front = items.pop(0)                     # Pobramie/usunięcie pierwszego elementu
        if not isinstance(front, list):
            tot += front                         # Bezpośrednie dodawanie liczb
            note(trace, front)
        else:
            items.extend(front)                  # <== Dołączenie wszystkich zagnieżdżonych list
    return tot

tester(sumtree)
print('-'*40)



# Najpierw w głąd według elementów - dodawanie na początek (podobnie jak w wersji z rekurencją)

def sumtree(L, trace=False):                     # Najpierw wgłąb, jawny stos
    tot = 0
    items = list(L)                              # Rozpoczęcie od kopi na najwyższym poziomie   
    while items:
        more(items)
        front = items.pop(0)                     # Pobramie/usunięcie pierwszego elementu
        if not isinstance(front, list):
            tot += front                         # Bezpośrednie dodawanie liczb
            note(trace, front)
        else:
            items[:0] = front                    # <== Dołączenie wszystkich zagnieżdżonych list na początek
    return tot

tester(sumtree)
print('-'*40)



# Najpierw wszerz według poziomów (alternatywny kod)

def sumtree(L, trace=True):
    tot = 0
    levels = [L]
    while levels:
        more(levels)
        front = levels.pop(0)                    # Pobranie/usunięcie pierwszej ścieżki
        for x in front:
            if not isinstance(x, list):
                tot += x                         # Bezpośrednie dodawanie liczb
                note(trace, x)
            else:
                levels.append(x)                 # Wypchnięcie/zaplanowanie zagnieżdżonych list
    return tot

tester(sumtree)
print('-'*40)



"""
Oczekiwany rezultat:

1, 6, 2, 5, 7, 8, 3, 4, 36
1, 2, 3, 4, 5, 15
5, 4, 3, 2, 1, 15
----------------------------------------
1, 2, 3, 4, 5, 6, 7, 8, 36
1, 2, 3, 4, 5, 15
1, 2, 3, 4, 5, 15
----------------------------------------
1, 6, 2, 5, 7, 8, 3, 4, 36
1, 2, 3, 4, 5, 15
5, 4, 3, 2, 1, 15
----------------------------------------
"""
