class SkipObject:
    def __init__(self, wrapped):                  # Zapisanie elementu, który ma być użyty
        self.wrapped = wrapped

    def __iter__(self):
        return SkipIterator(self.wrapped)         # Za każdym razem nowy iterator

class SkipIterator:
    def __init__(self, wrapped):
        self.wrapped = wrapped                    # Informacje o stanie iteratora
        self.offset  = 0

    def __next__(self):
        if self.offset >= len(self.wrapped):      # Zakończenie iteracji
            raise StopIteration
        else:
            item = self.wrapped[self.offset]      # Inaczej zwrócenie elementu i pominięcie
            self.offset += 2
            return item

if __name__ == '__main__':
    alpha = 'abcdef'
    skipper = SkipObject(alpha)                   # Utworzenie obiektu pojemnika
    I = iter(skipper)                             # Utworzenie na nim iteratora
    print(next(I), next(I), next(I))              # Odwiedzenie wartości przesunięcia 0, 2, 4

    for x in skipper:                # Pętla for automatycznie wywołuje __iter__
        for y in skipper:            # Zagnieżdżone for za każdym razem wywołują __iter__
            print(x + y, end=' ')    # Każdy iterator ma własny stan i przesunięcie

