from singletons1 import singleton

@singleton                                      # Person = singleton(Person)
class Person:                                   # Ponownie dowiązuje Person do onCall
     def __init__(self, name, hours, rate):     # onCall pamięta Person
        self.name = name
        self.hours = hours
        self.rate = rate
     def pay(self):
        return self.hours * self.rate

@singleton                                      # Hack = singleton(Hack)
class Hack:                                     # Ponownie dowiązuje Hack do onCall
    def __init__(self, val):                    # onCall pamięta Hack
        self.attr = val

bob = Person('Robert', 40, 10)                 # Tak naprawdę wywołuje onCall
print(bob.name, bob.pay())

anna = Person('Anna', 50, 20)                  # Ten sam pojedynczy obiekt
print(anna.name, anna.pay())

X = Hack(42)                                   # Jeden obiekt Person, jeden obiekt Hack
Y = Hack(99)
print(X.attr, Y.attr)


