"""
reloadall2.py: przechodnie przeładowanie zagnieżdżonych modułów.
Wersja alternatywna: rekurencja, refaktoryzacja.
"""

import types
from reloadall import status, tryreload, tester

def transitive_reload(objects, visited):
    for obj in objects:
        if type(obj) == types.ModuleType and obj not in visited:
            status(obj)
            tryreload(obj)                          # Przeładowanie bieżącego modułu i rekurencja 
            visited.add(obj)
            transitive_reload(obj.__dict__.values(), visited)

def reload_all(*args):
    transitive_reload(args, set())

if __name__ == '__main__':
    tester(reload_all, 'reloadall2')                # Autotest: przeładować swój moduł czy argumentu?

