class MyList:
    def __init__(self, start):
        #self.wrapped = start[:]                  # Skopiowanie start — brak efektów ubocznych
        self.wrapped = list(start)                # Upewniamy się, że jest to lista
    def __add__(self, other):
        return MyList(self.wrapped + other)
    def __mul__(self, time):
        return MyList(self.wrapped * time)
    def __getitem__(self, offset):                # Przekazane również jako wycinek [:]
        return self.wrapped[offset]               # Iterowanie, jeżeli brak __iter__
    def __len__(self):
        return len(self.wrapped)                  # Również jako rozwiązanie zapasowe dla testów prawdziwości 
    def append(self, node):
        self.wrapped.append(node)
    def __getattr__(self, name):                  # Inne metody: sort, reverse itd.
        return getattr(self.wrapped, name)
    def __repr__(self):                           # Metoda wyświetlająca wszystkie dane
        return repr(self.wrapped)

if __name__ == '__main__':
    x = MyList('hack')
    print(x)
    print(x[2])
    print(x[1:])
    print(x + ['code'])
    print(x * 3)
    x.append('1'); x.extend(['z'])
    x.sort()
    print(' '.join(c for c in x))

