# Instancje normalnie dziedziczą klasy i ich klasy nadrzędne

class SuperMetaObj:
    def __call__(self, classname, supers, classdict):
        print('W SuperMetaObj.call:', classname, supers, classdict, sep='\n...')
        Class = self.__New__(classname, supers, classdict)
        self.__Init__(Class, classname, supers, classdict)
        return Class

class SubMetaObj(SuperMetaObj):
    def __New__(self, classname, supers, classdict):
        print('W SubMetaObj.new: ', classname, supers, classdict, sep='\n...')
        return type(classname, supers, classdict)

    def __Init__(self, Class, classname, supers, classdict):
        print('W SubMetaObj.init:', classname, supers, classdict, sep='\n...')
        print('...inicjalizacja obiektu klasy:', list(Class.__dict__.keys()))

class Super:
    pass

print('Tworzenie klasy')
class Hack(Super, metaclass=SubMetaObj()):   # Wywołanie instancji Sub za pomocą Super.__call__
    data = 1                                    # Wywołanie na końcu instrukcji
    def meth(self, arg):
        return self.data + arg

print('Tworzenie instancji')
X = Hack()
print('Attrybuty:', X.data, X.meth(2))

