class tracer(object):
    def __init__(self, func):                # W momencie dekoracji @
        self.calls = 0                       # Zapisanie func na potrzeby późniejszego wywołania
        self.func  = func
    def __call__(self, *args, **kwargs):     # W momencie wywołania oryginalnej funkcji
        self.calls += 1
        print(f'wywołanie {self.calls} to {self.func.__name__}')
        return self.func(*args, **kwargs)
    def __get__(self, instance, owner):                # W momencie pobrania metody
        def wrapper(*args, **kwargs):                  # Zachowanie obu instancji
            return self(instance, *args, **kwargs)     # Wykonuje __call__
        return wrapper


@tracer
def hack(a, b, c):                           # hack = tracer(hack)
    print(a + b + c)                         # Wykorzystuje jedynie __call__

class Person:
    def __init__(self, name, pay):
        self.name = name
        self.pay  = pay
    @tracer                                  # giveRaise = tracer(giveRaise)
    def giveRaise(self, percent):            # Sprawia, że giveRaise staje się deskryptorem
        self.pay *= (1.0 + percent)

