from rangetest0 import rangetest
print(f'{__debug__=}')                     # False, jeśli "python –O main.py"

@rangetest((1, 0, 120))                    # persinfo = rangetest(...)(persinfo)
def persinfo(name, age):                   # age musi się mieścić w przedziale 0..120
    print(f'{name} ma {age} lat')

@rangetest([0, 1, 12], [1, 1, 31], [2, 0, 2024])
def birthday(M, D, Y):
    print(f'Data urodzenia = {M}/{D}/{Y}')

class Person:
    def __init__(self, name, job, pay):
        self.job  = job
        self.pay  = pay

    @rangetest([1, 0.0, 1.0])              # giveRaise = rangetest(...)(giveRaise)
    def giveRaise(self, percent):          # Argument 0 to tutaj instancja self
        self.pay = int(self.pay * (1 + percent))

# Wiersze z komentarzem zgłaszają błąd TypeError, o ile w wierszu poleceń powłoki nie wykorzystano "python –O"

persinfo('Robert Zielony', 45)           # Tak naprawdę wykonuje onCall(...) ze stanem
#persinfo('Robert Zielony', 200)         # Lub person, jeśli ustawiono argument wiersza poleceń –O

birthday(8, 31, 2024)
#birthday(8, 32, 2024)

anna = Person('Anna Czerwona', 'programista', 100000)
anna.giveRaise(.10)                       # Tak naprawdę wykonuje onCall(self, .10)
print(anna.pay)                           # Lub giveRaise(self, .10), jeśli z –O
#anna.giveRaise(1.10)


