r"""
Emulacja działania funkcji 'print' z Pythona 3.x w postaci kodu, który można dowolnie dostosowywać.
Składnia wywołania: print3(*args, sep=' ', end='\n', file=sys.stdout)
"""
import sys

def print3(*args, **kargs):
    sep  = kargs.get('sep', ' ')            # Wartości domyślne argumentów-słów kluczowych
    end  = kargs.get('end', '\n')
    file = kargs.get('file', sys.stdout)
    output = ''                             # Tworzenie i wyświetlanie łańcucha znaków
    first  = True
    for arg in args:
        output += ('' if first else sep) + str(arg)
        first = False
    file.write(output + end)

