"""
Narzędzie do przeglądania folderu poczty przychodzącej oraz utrzymywania jej
Przegląda skrzynkę e-mailową POP, pobierając tylko
nagłówki i pozwalając na usuwanie bez pobierania pełnej wiadomości.
"""

import poplib, getpass, sys

mailserver = 'nazwa serwera POP naszej poczty'   # Zmień na swój pop.server.net
mailuser   = 'identyfikator użytkownika poczty'      # Zmień na swoją nazwę użytkownika
mailpasswd = getpass.getpass(f'Hasło dla {mailserver}? ')

print('Łączenie...')
server = poplib.POP3(mailserver)
server.user(mailuser)
server.pass_(mailpasswd)

try:
    print(server.getwelcome())
    msgCount, mboxSize = server.stat()
    print('W skrzynce jest', msgCount, 'wiadomości email, rozmiar ', mboxSize)
    msginfo = server.list()
    print(msginfo)
    for i in range(msgCount):
        msgnum  = i+1
        msgsize = msginfo[1][i].split()[1]
        resp, hdrlines, octets = server.top(msgnum, 0)         # Pobranie tylko nagłówków
        print('-'*80)
        print('[%d: octets=%d, size=%s]' % (msgnum, octets, msgsize))
        for line in hdrlines: print(line)

        if input('Drukować?') in ['y', 'Y']:
            for line in server.retr(msgnum)[1]: print(line)    # Pobranie całej wiadomości
        if input('Usunąć?') in ['y', 'Y']:
            print('usuwanie')
            server.dele(msgnum)                                # Usunięcie z serwera
        else:
            print('pomijanie')
finally:
    server.quit()                                  # Należy odblokować skrzynkę mbox
input('Żegnaj.')                                      # Zachowanie okna

