"""
mydir.py: moduł wyświetlający przestrzenie nazw innych modułów
Zaimportuj listing tego modułu i przekaż zaimportowany moduł
lub uruchom ten plik jako skrypt, aby uruchomić jego kod testowy.
"""

sepchr = '-'
seplen = 60

def listing(module, verbose=True, unders=True):
    """
    Lista modułów: tylko atrybuty, jeśli verbose=False
    ukrycie wbudowanych atrybutów __X__ jeśli unders=False. 
    """
    sepline = sepchr * seplen
    if verbose:
        print(sepline)
        print(f'name: {module.__name__}\nfile: {module.__file__}')
        print(sepline)

    # Przeskanowanie kluczy przestrzeni nazw
    for (count, attr) in enumerate(sorted(module.__dict__)):
        prefix = f'{count + 1:02d}) {attr}'
        if attr.startswith('__'):
            if unders:
                print(prefix, '<built-in name>')    # Skip __file__, etc.
        else:
            print(prefix, getattr(module, attr))    # Or module.__dict__[attr]

    if verbose:
        print(sepline)
        print(f'{module.__name__} has {count + 1} names')
        print(sepline)

if __name__ == '__main__':
    import mydir
    listing(mydir)                                  # Self-test code: list myself

