# state = 1 lub 
#   [1, 2, 3] lub [0, 2, 3] lub (1, 2, 3) lub (0, 2, 3) lub 
#   dict(a=1, b=2, c=3) lub dict(a=0, b=2, c=3) lub inne

state = dict(a=0, b=2, c=3)

match state:
    case 1 | 2 | 3 as what:              # Dopasowanie literałów liczb całkowitych, what = 1
        print('lub', what)

    case [1, 2, what]:                   # Dopasowanie sekwencji (1), what = 3
        print('lista', what)
    case [0, *what]:                     # Dopasowanie sekwencji (0), what = [2, 3]
        print('lista', what)

    case {'a': 1, 'b': 2, 'c': what}:    # Dopasowanie odwzorowania, what = 3
        print('słownik', what)
    case {'a': 0, **what}:               # Dopasowanie odwzorowania, what = {'b': 2, 'c': 3}
        print('słownik', what)

    case (1, 2, what):                   # Dopasowanie sekwencji: tak samo jak [1, 2, what] 
        print('krotka', what)
    case (0, *what):                     # Dopasowanie sekwencji: tak samo jak [0, *what]
        print('krotka', what)

    case _ as what:                      # Dopsowanie pozostałych, what = other
        print('inne', what)
