X = 11                       # Globalna zmienna/atrybut z modułu (X lub manynames.X po zaimportowaniu)

def f():
    print(X)                 # Dostęp do zmiennej globalnej X zgodnie z zasadami wyszukiwania LEGB

def g():
    X = 22                   # Zmienna lokalna (funkcji) — X ukrywa X z modułu
    print(X)

class C:
    X = 33                   # Atrybut klasy C.X (self.X pre self.m())
    def m(self):
        X = 44               # Lokalna (funkcja) X w metodzie (tutaj nieużywana)
        self.X = 55          # Atrybut instancji self.X (przysłania klasę X)

if __name__ == '__main__':
    print(X)                 # 11: moduł (czyli manynames.X poza plikiem)
    f()                      # 11: zmienna globalna
    g()                      # 22: zmienna lokalna
    print(X)                 # 11: zmienna modułu bez zmian

    I = C()                  # Utworzenie instancji
    print(I.X)               # 33: zmienna klasy odziedziczona przez instancję
    I.m()                    # Dołączenie nazwy atrybutu X do instancji
    print(I.X)               # 55: instancja
    print(C.X)               # 33: klasa (czyli obj.X jeśli nie ma X w instancji)

    #print(C.m.X)            # PORAŻKA: widoczna tylko w metodzie
    #print(g.X)              # PORAŻKA: widoczna tylko w funkcji

