"""
Implementacja przecięcia i sumy dla jednego lub więcej argumentów. Dane wejściowe mogą być dowolnym iterowalnym obiektem, który obsługuje wielokrotne testy in, a wyniki zawsze są listami. Ta funkcja przecięcia unika duplikatów w wynikach dzięki testowi in, ale może wolno działać: popraw mnie.
"""

def intersect(*args):
    res = []
    for x in args[0]:                    # Przejście przez pierwszą sekwencję
        if x in res: continue            # Pominięcie duplikatów w [0]
        for other in args[1:]:           # Dla wszystkich pozostałych argumentów
            if x not in other: break     # Czy w każdym jest element?
        else:                            # Nie: wyjście z pętli
            res.append(x)                # Tak: dodaj elementy na koniec listy
    return res

def union(*args):
    res = []
    for seq in args:                     # Dla wszystkich argumentów
        for x in seq:                    # Dla wszystkich elementów w tym argumencie
            if not x in res:
                res.append(x)            # Dodanie nowych elementów do wyniku
    return res

