"""
Plik access_builtins.py (z przykładu 39.22., access_builtins_mixin_desc.py).
Przekierowanie niektórych wbudowanych operacji z powrotem do klasy pośredniczącej,
dzięki czemu działają tak samo w wersji 3.x, jak wywoływane bezpośrednio po nazwach
i w domyślnych klasach w wersji 2.x. Kod w miarę potrzeby można rozszerzyć tak, aby
obejmował inne nazwy __X__ wykorzystywane w obiektach pośredniczących.

"""

class BuiltinsMixin:
    class ProxyDesc:                                          # Definicja deskryptora
        def __init__(self, attrname):
            self.attrname = attrname
        def __get__(self, instance, owner):
            return instance.__getattr__(self.attrname)        # Uruchomienie walidacji

    builtins = ['add', 'str', 'getitem', 'call']              # Inne niezbędne operacje
    for attr in builtins:
        exec(f'__{attr}__ = ProxyDesc("__{attr}__")')         # Utworzenie deskryptora


