# asyncpg-basic.py - listing 4.21
import asyncio
import asyncpg
import datetime
from util import Database

async def main():
  async with Database('test', owner=True) as conn:
    await demo(conn)

async def demo(conn: asyncpg.Connection):
  await conn.execute('''
    CREATE TABLE users(
      id serial PRIMARY KEY,
      name text,
      dob date
    )'''
  )

  pk = await conn.fetchval(
    'INSERT INTO users(name, dob) VALUES($1, $2) '
    'RETURNING id', 'Kuba', datetime.date(1984, 3, 1)
  )

  async def get_row():
    return await conn.fetchrow(
      'SELECT * FROM users WHERE name = $1',
      'Kuba'
    )
  print('Po wykonaniu polecenia INSERT:', await get_row())

  await conn.execute(
    'UPDATE users SET dob = $1 WHERE id=1',
    datetime.date(1985, 3, 1)
  )
  print('Po wykonaniu polecenia UPDATE:', await get_row())

  await conn.execute(
    'DELETE FROM users WHERE id=1'
  )
  print('Po wykonaniu polecenia DELETE:', await get_row())

if __name__ == '__main__':
  asyncio.run(main())
