# shell_signal02.py - listing 3.34
import asyncio
from signal import SIGINT, SIGTERM

async def main():
  try:
    while True:
      print('<Twoja aplikacja działa...>')
      await asyncio.sleep(1)
  except asyncio.CancelledError:
    for i in range(3):
      print('<Twoja aplikacja jest zamykana...>')
      await asyncio.sleep(1)

def handler(sig):
  loop.stop()
  print('Odebrano sygnał: {sig!s}, zamykamy aplikację.')
  loop.remove_signal_handler(SIGTERM)
  loop.add_signal_handler(SIGINT, lambda: None)

if __name__ == '__main__':
  loop = asyncio.get_event_loop()
  for sig in (SIGTERM, SIGINT):
    loop.add_signal_handler(sig, handler, sig)
  loop.create_task(main())
  loop.run_forever()
  tasks = asyncio.all_tasks(loop=loop)
  for t in tasks:
    t.cancel()
  group = asyncio.gather(*tasks, return_exceptions=True)
  loop.run_until_complete(group)
  loop.close()
