from abc import ABC, abstractmethod


class Predator(ABC):  # <1>
    @abstractmethod  # <2>
    def eat(self, prey):  # <3>
        pass # <4>


class Bear(Predator):  # <5>
    def eat(self, prey):  # <6>
        print(f'Pożera {prey}!')


class Owl(Predator):
    def eat(self, prey):
        print(f'Porywa {prey}!')


class Chameleon(Predator):
    def eat(self, prey):
        print(f'Strzela językiem w {prey}!')


if __name__ == '__main__':
    bear = Bear()
    bear.eat('jelenia')
    owl = Owl()
    owl.eat('mysz')
    chameleon = Chameleon()
    chameleon.eat('muchę')
