class BigCat:
    def eats(self):
        return ['gryzonie']


class Lion(BigCat):  # <1>
    def eats(self):
        return ['gnu']
        # return super().eats() + ['gnu']  # cooperative version


class Tiger(BigCat):  # <2>
    def eats(self):
        return ['wodny bawół']
        # return super().eats() + ['wodny bawół']  # cooperative version


class Liger(Lion, Tiger):  # <3>
    def eats(self):
        return super().eats() + ['królik', 'krowa', 'świnia', 'kurczak']


if __name__ == '__main__':
    lion = Lion()
    print('Lew zjada', lion.eats())
    tiger = Tiger()
    print('Tygrys zjada', tiger.eats())
    liger = Liger()
    print('Legrys zjada', liger.eats())
