# Python For DevOps: Learn Ruthlessly Effective Automation
#### Publisher:  [O'Reilly Media](http://shop.oreilly.com/product/0636920274902.do)
#### Release Date:  December 31st, 2019

![Python for Unix and Linux System Administration](https://www.noahgift.com/img/python_devops.png)
* [Buy a Physical Copy from Amazon](https://www.amazon.com/Python-DevOps-Ruthlessly-Effective-Automation-dp-149205769X/dp/149205769X)
* [Buy a Kindle Copy from Amazon](https://www.amazon.com/Python-DevOps-Ruthlessly-Effective-Automation-ebook-dp-B082P97LDW/dp/B082P97LDW)
* [Buy a Physical Copy from Barnes and Noble](https://www.barnesandnoble.com/w/python-for-devops-noah-gift/1132124390?ean=9781492057697#/)
* [Buy a Nook Book Copy from Barnes and Noble](https://www.barnesandnoble.com/w/python-for-devops-noah-gift/1132124390?ean=9781492057642#/)
* [Read Online](http://shop.oreilly.com/product/0636920274902.do)
* [Download Source Code from Github](https://github.com/paiml/python_devops_book)
* [Python for DevOps Website](https://pythondevops.com/)

#### Build Status
[![CircleCI](https://circleci.com/gh/paiml/python_devops_book.svg?style=svg)](https://circleci.com/gh/paiml/python_devops_book)

### Abstract
Much has changed in technology over the past decade. Data is hot, the cloud is ubiquitous, and many organizations need some form of automation. Throughout these transformations, Python has become one of the most popular languages in the world. This practical resource shows you how to use Python for everyday Linux systems administration tasks with today’s most useful DevOps tools, including Docker, Kubernetes, and Terraform.

Learning how to interact and automate with Linux is essential for millions of professionals. Python makes it much easier. With this book, you’ll learn how to develop software and solve problems using containers, as well as how to monitor, instrument, load-test, and operationalize your software. Looking for effective ways to "get stuff done" in Python? This is your guide.

Python foundations, including a brief introduction to the language
How to automate text, write command-line tools, and automate the filesystem
Linux utilities, package management, build systems, monitoring and instrumentation, and automated testing
Cloud computing, infrastructure as code, Kubernetes, and serverless
Machine learning operations and data engineering from a DevOps perspective
Building, deploying, and operationalizing a machine learning project

## Book Outline

### Chapter 1: Python Essentials for DevOps
### Chapter 2: Automating Files and the Filesystem
### Chapter 3: Working with the Command Line

* [Source Case Study](https://github.com/noahgift/nuclear_powered_command_line_tools)
* [GPU Programming Colab Notebook](https://github.com/noahgift/cloud-data-analysis-at-scale/blob/master/GPU_Programming.ipynb)
* [Notes](https://paiml.github.io/python_devops_book/notes/chap3)

### Chapter 4: Useful Linux Utilities
### Chapter 5:  Package Management
### Chapter 6:  Continuous Integration and Continuous Deployment

* [Source](https://github.com/noahgift/hugotools)
* [Notes](https://paiml.github.io/python_devops_book/notes/chap6)

### Chapter 7: Monitoring and Logging
### Chapter 8: Pytest for DevOps
### Chapter 9: Cloud Computing

* [Source](https://github.com/paiml/python_devops_book/tree/master/src/chap9)
* [Notes](https://paiml.github.io/python_devops_book/notes/chap9)

### Chapter 10: Infrastructure as Code
### Chapter 11: Container Technologies: Docker and Docker Compose
### Chapter 12: Container Orchestration: Kubernetes
### Chapter 13: Serverless Technologies
### Chapter 14: MLOps and Machine learning Engineering

* [Source](https://github.com/paiml/python_devops_book/tree/master/src/chap14) 
* [Notes](https://paiml.github.io/python_devops_book/notes/chap14)

### Chapter 15: Data Engineering

* [Source](https://github.com/noahgift/awslambda)

### Chapter 16: DevOps War Stories and Interviews

## Got Feedback?

If you have any suggestions as the book is being developed please [create a ticket](https://github.com/paiml/python_devops_book/issues) and let us know!  Thanks for helping make this an incredible book.

## FAQ

A list of Frequently Asked Questions about the book:

* [FAQ](https://paiml.github.io/python_devops_book/docs/faq)

## Addendum

Updates on new material post book release.

* [Addendum](https://paiml.github.io/python_devops_book/docs/addendum.md)

## Contact Authors

### Noah Gift

* [Noah Gift Website](https://noahgift.com)
* [Noah Gift Linkedin](https://www.linkedin.com/in/noahgift)
* [Sign up for Pragmatic Labs Mailing List](https://newsletter.paiml.com/social)
* [Read other books by Noah Gift](https://www.noahgift.com/books/latest/)
* [Take courses by Noah Gift](https://www.noahgift.com/courses/latest/)
* [Watch Videos by Noah Gift](https://www.noahgift.com/videos/latest/)

### Kennedy Behrman

* [Kennedy Behrman Linkedin](https://www.linkedin.com/in/kennedybehrman/)

### Alfredo Deza

* [Alfredo Deza](https://www.alfredodeza.com/)

### Grig Gheorghiu

* [Grig Gheorghiu](https://www.linkedin.com/in/ggheorghiu/)
