# Zaimportowanie modułów
import numpy as np
from matplotlib import pyplot as plt
import matplotlib.ticker as ticker

# Dane do wyświetlenia na wykresie
salaries = [4982, 5006, 5178, 5195, 5211, 5223, 5228, 5404, 5412, 5428, 5428, 5437, 
 5482, 5519, 5551, 5555, 5592, 5605, 5625, 5637, 5642, 5650, 5650, 5781, 5801, 5801, 
 5814, 5822, 5830, 5847, 5863, 5879, 5892, 5949, 5961, 6015, 6027, 6039, 6056, 6064, 
 6068, 6207, 6216, 6240, 6269, 6330, 6343, 6371, 6404, 6494, 6539, 6626, 6850, 7101]

# Przygotowanie histogramu
fig, ax = plt.subplots()
fig.set_size_inches(5.6, 4.2)
ax.hist(salaries, bins=np.arange(4800, 7201, 150), edgecolor='black', linewidth=1.2)
formatter = ticker.FormatStrFormatter('%1.0f')
ax.xaxis.set_major_formatter(formatter)
plt.title('Miesięczne wynagrodzenie w dziale sprzedaży')
plt.xlabel('Wynagrodzenie (rozpiętość słupka = 150)')
plt.ylabel('Częstotliwość')

# Wyświetlenie histogramu
plt.show()