import numpy as np
salaries = [4982, 5006, 5178, 5195, 5211, 5223, 5228, 5404, 5412, 5428, 5428, 5437, 
            5482, 5519, 5551, 5555, 5592, 5605, 5625, 5637, 5642, 5650, 5650, 5781, 5801, 5801, 
            5814, 5822, 5830, 5847, 5863, 5879, 5892, 5949, 5961, 6015, 6027, 6039, 6056, 6064, 
            6068, 6207, 6216, 6240, 6269, 6330, 6343, 6371, 6404, 6494, 6539, 6626, 6850, 7101]
count, labels = np.histogram(salaries, bins=np.arange(4800, 7201, 150))
labels = [''+str(labels[i])+'-'+str(labels[i+1])+' PLN' for i, _ in enumerate(labels[1:])]
non_zero_pos = [i for i, x in enumerate(count) if x != 0]
labels = [e for i, e in enumerate(labels) if i in non_zero_pos]
count = [e for i, e in enumerate(count) if i in non_zero_pos]

lbls = [labels[i] for i,c in enumerate(count) if c>2]
cnt = [c for c in count if c>2]  
cnt.append(sum(count) - sum(cnt))
lbls.append('Pozostałe')

from matplotlib import pyplot as plt
plt.pie(cnt, labels=lbls, autopct='%1.1f%%')
plt.title('Miesięczne wynagrodzenie w dziale sprzedaży')
plt.show() 
