import pandas as pd

orders = [
 (9423517, '2021-08-04', 9001),
 (4626232, '2021-08-04', 9003),
 (9423534, '2021-08-04', 9001),
 (9423679, '2021-08-05', 9002),
 (4626377, '2021-08-05', 9003),
 (4626412, '2021-08-05', 9004),
 (9423783, '2021-08-06', 9002),
 (4626490, '2021-08-06', 9004)
]

df_orders = pd.DataFrame(orders, columns =['NumZam', 'Data', 'NumPrac'])

details = [
  (9423517, 'Dżinsy', 'Rip Curl', 87.0, 1),
  (9423517, 'Kurtka', 'The North Face', 112.0, 1),
  (4626232, 'Skarpety', 'Vans', 15.0, 1),
  (4626232, 'Dżinsy', 'Quiksilver', 82.0, 1),
  (9423534, 'Skarpety', 'DC', 10.0, 2),
  (9423534, 'Skarpety', 'Quiksilver', 12.0, 2),
  (9423679, 'T-shirt', 'Patagonia', 35.0, 1),
  (4626377, 'Bluza', 'Animal', 44.0, 1),
  (4626377, 'Szorty taktyczne', 'Animal', 38.0, 1),
  (4626412, 'T-shirt', 'Volcom', 78.0, 1),
  (9423783, 'Bokserki', 'Superdry', 30.0, 2),
  (9423783, 'Szorty', 'Globe', 26.0, 1),
  (4626490, 'Szorty taktyczne', 'Billabong', 54.0, 1),
  (4626490, 'Sweter', 'Dickies', 56.0, 1)
]
# Konwersja słownika na obiekt DataFrame
df_details = pd.DataFrame(details, columns =['NumZam', 'Produkt', 'Marka', 'Cena', 'Ilosc'])

emps = [
  (9001, "Piotr Rabanowicz", "Wrocław"),
  (9002, "Joanna Broniewicz", "Poznań"),
  (9003, "Tomasz Wielgus", "Kraków"),
  (9004, 'Maja Zalewska', 'Lublin')
]

df_emps = pd.DataFrame(emps, columns =['NumPrac', 'Personalia', 'Lokalizacja'])

locations = [
  ('Wrocław', 'Zachód'),
  ('Poznań', 'Zachód'),
  ('Kraków', 'Wschód'),
  ('Lublin', 'Wschód')
]

df_locations = pd.DataFrame(locations, columns =['Lokalizacja', 'Region'])

df_sales = df_orders.merge(df_details) 

print(df_sales)

df_sales['Wartosc'] = df_sales['Cena'] * df_sales['Ilosc']

df_sales = df_sales[['Data','NumPrac','Wartosc']]

df_sales_emps = df_sales.merge(df_emps)
df_result = df_sales_emps.merge(df_locations) 

df_result = df_result[['Data','Region','Wartosc']] 

df_date_region = df_result.groupby(['Data','Region']).sum() 

ps = df_date_region.sum(axis = 0)

ps.name=('Wszystkie','Wszystkie')

df_date_region_total = df_date_region.append(ps)

df_totals = pd.DataFrame()
for date, date_df in df_date_region.groupby(level=0):
  df_totals = df_totals.append(date_df)
  ps = date_df.sum(axis = 0)
  ps.name=(date,'Wszystkie')
  df_totals = df_totals.append(ps)

df_totals = df_totals.append(df_date_region_total.loc[('Wszystkie','Wszystkie')])

df_totals.sort_index(ascending=True, inplace=True)
df_totals.loc[(slice('2021-08-04', '2021-08-06'), slice('Wschód', 'Zachód')), :]

