import pandas as pd

data = [{ "Prac":"Piotr Rabanowicz",
  "Prac_email": "piotr.rabanowicz",
  "ObsZam":[{"NumZam":2608,"Wartosc":35},
            {"NumZam":2617,"Wartosc":35},
            {"NumZam":2620,"Wartosc":139}
   ]},
   {"Prac":"Joanna Broniewicz",
   "Prac_email": "jan.broniewicz",
   "ObsZam":[ {"NumZam":2621,"Wartosc":95},
            {"NumZam":2626,"Wartosc":218}
    ]
}]


df = pd.json_normalize(data, "ObsZam", ["Prac","Prac_email"]).set_index(["Prac","Prac_email","NumZam"])
df = df.reset_index()
json_doc = (df.groupby(['Prac',"Prac_email"], as_index=True)
.apply(lambda x: x[['NumZam','Wartosc']].to_dict('records'))
.reset_index()
.rename(columns={0:'ObsZam'})
.to_json(orient='records'))
print(json_doc)
