# counter.py

def policz_slowa(slowa):
    """przyjmuje liste czystych slow, zwraca slownik ilosci"""
    licznik_slow = {}
    for slowo in slowa:
		try: 
			liczba = licznik_slow.setdefault(slowo, 0)
		except TypeError:
			#jeśli ze 'slowa' nie można wyliczć wartości skrótu nieodwracalnego, przejdź dalej
            pass
        licznik_slow[slowo] += 1
    return licznik_slow


def statystyka_slow(licznik_slow):
    """przyjmuje slownik ilosci slow i zwraca pierwsze i ostatnie 5"""
    lista_slow = list(licznik_slow.items())
    lista_slow.sort(key=lambda x: x[1])
    try:
		najmniej_popularne = lista_slow[:5]
		najbardziej_popularne = lista_slow[-1:-6:-1]
	except IndexError as e:
	# jeśli lista jest pusta lub zbyt krótka, po prostu zwróć listę
		najmniej_popularne = lista_slow
		najbardziej_popularne = list(reversed(lista_slow))
    return najbardziej_popularne, najmniej_popularne