'''
Ten plik app.py należy stosować razem z szablonem Heroku ze
strony https://github.com/datademofun/heroku-basic-flask.

Dodaj moduł twilio do pliku requirements.txt i zastąp plik
app.py tym plikiem.

Więcej informacji znajdziesz w tekście rozdziału 9.
'''
from flask import Flask, request
from twilio.twiml.messaging_response import MessagingResponse

app = Flask(__name__)


@app.route('/')
def homepage():
    return 'Wszystko działa!'


@app.route("/sms", methods=['GET', 'POST'])
def sms_reply():

    from_number = request.form['From']
    body = request.form['Body']
    resp = MessagingResponse()

    msg = (f'Super! Wielkie dzięki za wiadomość z numeru {from_number}, '
           f'Odpowiadam tym samym - "{body}".')

    resp.message(msg)
    return str(resp)


if __name__ == '__main__':
    app.run()
