# Automatyzacja zadań w Pythonie. Receptury

<a href="https://www.packtpub.com/application-development/python-automation-cookbook?utm_source=github&utm_medium=repository&utm_campaign=9781789133806 "> <img src="https://d1ldz4te4covpm.cloudfront.net/sites/default/files/imagecache/ppv4_main_book_cover/B10858.png" alt="Automatyzacja zadań w Pythonie. Receptury" height="256px" align="right"></a>

To repozytorium z kodem do książki Automatyzacja zadań w Pythonie (wersja oryginalna wydawnictow Packt; wydanie polskie wydawnictwo Helion).

**Poznaj świat automatyzacji, wykorzystując receptury w Pythonie, dzięki którym rozwiniesz swoje umiejętności**

## O czym jest ta książka?
Posługując się podejściem problem-rozwiązanie, pokazuję, jak automatyzować rozmaite nudne zadania i sprawić, by to komputer wykonywał je za Ciebie.
Użyjesz do tego języka programowania Python. Z tej książki nauczysz się identyfikować problemy i je eliminować, aby tworzyć niezawodne systemy
wysokiej jakości.

W tej książce omówione są następujące ekscytujące mechanizmy:
* Pobieranie informacji ze stron WWW, aby wykrywać wprowadzone w nich zmiany
* Wyszukiwanie i przetwarzanie plików z surowymi danymi sprzedażowymi, aby łączyć informacje w arkuszach kalkulacyjnych
* Omówienie technik pobierania informacji z arkuszy Excela i generowania atrakcyjnych raportów z wykresami
* Przegląd technik potrzebnych do generowania losowych i czytelnych w druku kodów używanych na jednorazowych kuponach rabatowych
* Automatyczne generowanie kampanii marketingowej i łączenie się z odbiorcami z użyciem różnych kanałów
* Identyfikowanie i implementowanie rozwiązań

## Instrukcje i poruszanie się po kodzie
Cały kod jest umieszczony w katalogach (na przykład R02).

Kod ma następująca postać:
```
# INSTRUKCJE IMPORTU
from sale_log import SaleLog
def get_logs_from_file(shop, log_filename):
def main(log_dir, output_filename):
...
if __name__ == '__main__':
# PRZETWARZANIE ARGUMENTÓW WIERSZA POLECEŃ I WYWOŁANIE main()
```

**Czego będziesz potrzebować w trakcie lektury tej książki:**
Powinieneś znać podstawy Pythona. Nie zakładam jednak, że jesteś ekspertem od tego języka. Powinieneś umieć wprowadzać instrukcje w wierszu poleceń
(Terminalu, Bashu itp.). Aby zrozumieć kod z tej książki, będziesz potrzebować edytora, który umożliwia wczytywanie i edycję kodu. Możesz też używać
środowiska IDE z obsługą języka Python, na przykład https://realpython.com/python-ides-code-editors-guide/.

Podane poniżej oprogramowanie umożliwia wykonanie wszystkich plików z kodem z tej książki.
### Lista oprogramowania
| Rozdział | Potrzebne oprogramowanie             | Wymagany system operacyjny          |
| -------- | ------------------------------------ | ----------------------------------- |
| 1-10     | Python 3.7 https://www.python.org    | Windows, macOS, and Linux (Any)     |


Dostępny jest też plik PDF z kolorowymi zrzutami i diagramami z oryginalnego wydania książki. [Kliknij, aby go pobrać](https://www.packtpub.com/sites/default/files/downloads/9781789133806_ColorImages.pdf).

## O autorze
**Jaime Buelta**
W trakcie swojej kariery był zawodowym programistą pracującym z Pythonem i miał styczność z wieloma różnymi technologiami. Tworzył oprogramowanie
dla różnych branż, w tym systemy dla lotnictwa oraz firm zajmujących się sieciami i komunikacją, przemysłowe systemy SCADA, internetowe gry komputerowe,
a także usługi finansowe. Współpracował przy tym ściśle z różnymi jednostkami, w tym z działami marketingu, zarządzania, sprzedaży i projektowania gier, 
pomagając firmom w osiąganiu ich celów. Jest gorącym zwolennikiem automatyzowania wszelkich zadań i zmuszania komputerów do wykonywania ciężkich operacji,
dzięki czemu użytkownicy mogą się skupić na ważnych kwestiach. Obecnie mieszka w Dublinie w Irlandii i regularnie wygłasza prelekcje na konferencji 
PyCon Ireland.

