

def ObtainAggregated(*args):
    # Pobieranie dokumentu z kontekstu
    # dostępnego dla wszystkich skryptów.
    desktop = XSCRIPTCONTEXT.getDesktop()
    model = desktop.getCurrentComponent()

    # Pobieranie pierwszego arkusza.
    sheet = model.Sheets.getByIndex(0)

    # Znajdowanie kolumny z liczbą widzów.
    MAX_ELEMENT = 20
    for column in range(0, MAX_ELEMENT):
        cell = sheet.getCellByPosition(column, 0)
        if 'Widzowie' in cell.String:
            break
    else:
        raise Exception('Nie znaleziono kolumny z liczbą widzów')

    accumulator = 0.0
    for row in range(1, MAX_ELEMENT):
        cell = sheet.getCellByPosition(column, row)
        value = cell.getValue()
        if value:
            accumulator += cell.getValue()
        else:
            break

    cell = sheet.getCellByPosition(column, row)
    cell.setValue(accumulator)

    cell = sheet.getCellRangeByName("A15")
    cell.String = 'W sumie'
    return None
