'''
Ten skrypt wczytuje plik CSV i generuje inny plik CSV ze zagregowanymi danymi.
'''
import csv
import argparse
import pandas as pd


def pandas_format(row):
    row['DATA'] = pd.to_datetime(row['CZAS_STANDARDOWY'])
    row['USD'] = pd.to_numeric(row['USD'])

    return row


def calculate_results(reader):
    # Wczytywanie i formatowanie danych.
    data = pd.DataFrame(pandas_format(r) for r in reader)
    by_usd = data.groupby(data['DATA'].dt.date)['USD']
    result = by_usd.agg(['sum', 'count', 'mean'])

    # Zaokrąglanie do dwóch miejsc po przecinku.
    result = result.round(2)

    # Zmiana nazw kolumn.
    result = result.rename(columns={
        'sum': 'USD W SUMIE',
        'count': 'LICZBA',
        'mean': 'ŚREDNIA',
    })

    return result


def main(input_file, output_file):
    reader = csv.DictReader(input_file)
    result = calculate_results(reader)

    # Zapisywanie pliku w formacie csv.
    output_file.write(result.to_csv())


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument(dest='input', type=argparse.FileType('r'),
                        help='Plik wejściowy')
    parser.add_argument(dest='output', type=argparse.FileType('w'),
                        help='Plik wyjściowy')
    args = parser.parse_args()
    main(args.input, args.output)
