import requests
import parse

NAMES = [
    'John Smyth',
    'Michael Craig',
    'Poppy-Mae Pate',
    'Vivienne Rennie',
    'Fathima Mccabe',
    'Mai Cordova',
    'Rocío García',
    'Roman Sullivan',
    'John Paul Smith',
    "Séamus O'Carroll",
    'Keagan Berg',
]

sorted_names = []
for name in NAMES:
    data = {
        'custname': name,
    }
    # Żądanie imienia i nazwiska z serwera.
    result = requests.get('http://httpbin.org/post', json=data)
    if result.status_code != 200:
        raise Exception(f'Błąd przy dostępie do serwera: {result}')
    # Pobieranie nieprzetworzonego imienia i nazwiska.
    raw_result = result.json()['data']
    # Pobieranie imienia i nazwiska z wyniku.
    full_name = parse.search('"custname": "{name}"', raw_result)['name']
    # Podział na imię i nazwisko.
    first_name, last_name = full_name.split()
    ready_name = f'{last_name}, {first_name}'
    # Dodawanie do listy imienia i nazwiska w formacie nazwisko, imię.
    sorted_names.append(ready_name)

# Odpowiednie sortowanie listy i wyświetlanie wyniku.
sorted_names.sort()
print(sorted_names)
