'''
Ten skrypt wczytuje plik dziennika i generuje plik CSV z tymi samymi danymi.
'''
import csv
import argparse
from datetime import datetime, timezone


def american_format(timestamp):
    '''
    Przekształcanie daty w formacie MM-DD-RRRR GG:MM:SS na format iso 8601.
    '''
    FORMAT = '%m-%d-%Y %H:%M:%S'

    parsed_tmp = datetime.strptime(timestamp, FORMAT)
    time_with_tz = parsed_tmp.astimezone(timezone.utc)
    isotimestamp = time_with_tz.isoformat()

    return isotimestamp


def add_std_timestamp(row):
    country = row['KRAJ']
    if country == 'USA':
        # Bez zmian
        row['CZAS_STANDARDOWY'] = american_format(row['CZAS'])
    elif country == 'KANADA':
        # Bez zmian
        row['CZAS_STANDARDOWY'] = row['CZAS']
    else:
        raise Exception('Country not found')

    return row


def main(input_file, output_file):
    reader = csv.DictReader(input_file)
    result = [add_std_timestamp(row) for row in reader]

    # Zapisywanie danych w formacie CSV.
    header = result[0].keys()
    writer = csv.DictWriter(output_file, fieldnames=header)
    writer.writeheader()
    writer.writerows(result)


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument(dest='input', type=argparse.FileType('r'),
                        help='Plik wejściowy')
    parser.add_argument(dest='output', type=argparse.FileType('w'),
                        help='Plik wyjściowy')
    args = parser.parse_args()
    main(args.input, args.output)
