﻿<?
// Ustawia oczekiwany typ treści odpowiedzi:
header("Content-type: application/xhtml+xml");
header("Cache-control: no-transform");
// Wyświetla deklarację języka XML:
echo '<?xml version="1.0" encoding="UTF-8"?>';
?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.1//EN"
"http://www.openmobilealliance.org/tech/DTD/xhtml-mobile11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta name="viewport" content="width=240,user-scalable=no" />
<title>Listing 5.5: Zakładki technologii AJAX</title>
<style type="text/css">
.tab {
               padding: 5px 10px 1px 10px;
               margin: 0px;
               background-color:#cccccc;
               border-width: 1px;
               border-style: solid;
               border-color: #666666;
               font-weight: normal;
               font-size: smaller;
               text-decoration: none;
}
.activeTab {
               padding: 5px 10px 1px 10px;
               margin: 0px;
               background-color:#ffffff;
               border-width: 1px 1px 0px 1px;
               border-style: solid;
               border-color: #666666;
               font-weight: bold;
               font-size: small;
               text-decoration: none;
}
#content {
               padding: 10px;
               margin: 0px;
               border-width: 1px;
               border-style: solid;
               border-color: #666666;
}
#loading {
               padding: 5px;
}
</style>
<script type="text/javascript">
// Zmienna globalna zawierająca egzemplarz obiektu XHR:
var req = null;
// Funkcja uzyskująca egzemplarz obiektu XMLHttpRequest stosowana w żądaniach technologii AJAX:
function getXHR() {
    if (window.XMLHttpRequest) {
        return new XMLHttpRequest();
    }
    else try {
        return new ActiveXObject('Msxml2.XMLHTTP');
    } catch(e) {
        try {
            return new ActiveXObject("Microsoft.XMLHTTP");
        } catch(e) {
            return null;
        }
    }
}

// Wykorzystuje technologię AJAX do aktualizacji treści strony.
// Zwraca wartość true, jeśli żądanie technologii AJAX zakończyło się pomyślnie (w przeciwnym razie zwraca wartość[MMP1] false):
function updateContent(url, id) {
    req = getXHR();
    if (req != null) {
        // Tworzy żądanie GET protokołu HTTP:
        req.open('GET', url);
        // Anonimowa funkcja zwrotna obsługująca zmiany stanu żądania internetowego:
        req.onreadystatechange = function() {
            // Stan równy 4 oznacza, że otrzymano odpowiedź:
            if (req.readyState == 4) {
                // Sprawdza, czy status ma wartość 200 (czy otrzymano odpowiedź z serwera WWW):
                if (req.status == 200) {
                    document.getElementById(id).innerHTML = req.responseText;
                } else {
                    document.getElementById(id).innerHTML = 'Could not retrieve data.';
                }
            }
            // Dla wszystkich pozostałych stanów wyświetla animowany obraz GIF wskazujący na ładowanie treści.
            else {
                document.getElementById(id).innerHTML = '<img id="loading"
                    src="http://learnto.mobi/books/bmwd/05/loading.gif"
                    width="16" height="16"/>';
            }
            return false;
        }
        // Inicjalizuje transakcję technologii AJAX:
        req.send('');
    } else {
        return false;
    }
    return true;
}

// To jest funkcja obsługująca zdarzenie onclick dla łączy w zakładkach.
// index - indeks klikniętej zakładki (liczony od zera)
function handleOnClick(index) {
    // Konstruuje identyfikator klikniętej zakładki:
    var tabId = "tab" + index;
    // Aktualizuje styl aktywnej zakładki:
    document.getElementById(tabId).setAttribute('class', 'activeTab');
    // Aktualizuje style nieaktywnych zakładek:
    if (index != 0) {
        document.getElementById("tab" + 0).setAttribute('class', 'tab');
    }
    if (index != 1) {
        document.getElementById("tab" + 1).setAttribute('class', 'tab');
    }
    if (index != 2) {
        document.getElementById("tab" + 2).setAttribute('class', 'tab');
    }
    // Wykorzystuje technologię AJAX do aktualizacji elementu div z identyfikatorem content.
    // Konstruuje adres URL używany do uzyskiwania zaktualizowanej treści:
    var url = "http://learnto.mobi/books/bmwd/05/5–5–" + index + ".php";
    // Jeśli żądanie technologii AJAX zostało pomyślnie zrealizowane, oryginalne łącze nie jest aktywowane:
    if (updateContent(url, "content")) {
        return false;
    }
    // Jeśli dotarliśmy aż tutaj, transakcja technologii AJAX musiała zakończyć się niepowodzeniem.
    // Aktywuje oryginalne łącze i ładuje stronę statyczną:
    return true;
}
</script>
<noscript><p>Ta przeglądarka nie obsługuje skryptów.</p></noscript>
</head>
<body>
<h1>Zakładki technologii AJAX</h1>
<div id="tabs">
<a href="5–5–0-static.php" id="tab0" class="activeTab"
    onclick="return handleOnClick(0);">Owoce</a>
<a href="5–5–1-static.php" id="tab1" class="tab"
    onclick="return handleOnClick(1);">Warzywa</a>
<a href="5–5–2-static.php" id="tab2"
    class="tab" onclick="return handleOnClick(2);">Miód</a>
</div>
<div id="content">Kliknij nazwę, aby aktywować zakładkę.</div>
</body>
</html>

