﻿<?php
// Formatuje logiczną wartość parametru:
function formatBoolean($value) {
    return $value ? ("Tak") : ("Nie");
}

// Formatuje wartość tablicową parametru:
function formatArray($value) {
    $output = "[";
    join(',’, $value);
    $output .= "]";
    return $output;
}

// Wyświetla element listy parametrów:
function writeCapability($name, $value) {
    $output = '<li><span class="capaName">' . $name . '</span>? <span
class="capaValue">';
    if (is_bool($value)) {
        $output .= formatBoolean($value);
    } else if (is_array($value)) {
        $output .= formatArray($value);
    } else {
        $output .= $value;
    }
    $output .= '</span></li>';
    return $output;
}

// Definiuje stałe stosowane w nagłówku i stopce strony:
define("TITLE", "Informacje o urządzeniu z bazy danych WURFL");
// Dołącza plik nagłówka:
require ("../../../includes/header.php");

// Inicjalizuje bazę danych WURFL:
require_once('./wurfl-php-1.r1/WURFL/WURFLManagerProvider.php');
$wurflConfigFile =
    "/home/webadmin/learnto.mobi/html/books/bmwd/04/wurfl/wurflconfig.xml";
$wurflManager = WURFL_WURFLManagerProvider::getWURFLManager($wurflConfigFile);

// Uzyskuje obiekt urządzenia na podstawie żądania protokołu HTTP:
$device = $wurflManager->getDeviceForHttpRequest($_SERVER);

// Wykorzystuje interfejs WURFL API do wyświetlenia parametrów urządzenia mobilnego:
?>
<p>Parametry urządzenia odczytane z bazy WURFL</p>
<ul>
<?= writeCapability("Aplikacja kliencka", $_SERVER['HTTP_USER_AGENT']) ?>
<?= writeCapability("Nazwa marki", $device->getCapability('brand_name')) ?>
<?= writeCapability("Nazwa modelu", $device->getCapability('model_name')) ?>
<?= writeCapability("Metoda sterowania", $device->getCapability('pointing_method')) ?>
<?= writeCapability("Szerokość ekranu", $device->getCapability('resolution_width')) ?>
<?= writeCapability("Wysokość ekranu", $device->getCapability('resolution_height')) ?>
<?= writeCapability("Urządzenie mobilne",
    $device->getCapability('is_wireless_device')) ?>
<?= writeCapability("Obsługa standardów WWW",
    $device->getCapability('device_claims_web_support')) ?>
<?= writeCapability("Preferowany język znaczników",
    $device->getCapability('preferred_markup')) ?>
<?= writeCapability("Obsługa klawiszy dostępu",
    $device->getCapability('access_key_support')) ?>
</ul>

<p>Kliknij tutaj, aby sprawdzić możliwości <a href="4–5.php">przełącznika WURFL</a>.</p>

<?
// Dołącza plik stopki:
require ("../../../includes/footer.php");
?>

