﻿<html>
<head><title>DeviceAtlas Transcoder Identification</title></head>
<body>
<?php
// Ten fragment kodu określa, czy dane żądanie zostało poddane procesowi transkodowania, a w razie
// możliwości dodatkowo identyfikuje źródłowe urządzenie mobilne.

// Inicjalizuje bazę danych DeviceAtlas:
require_once('deviceatlas/Mobi/Mtld/DA/Api.php');
$tree = Mobi_Mtld_DA_Api::getTreeFromFile("deviceatlas/20091028.json");

// Odnajduje identyfikator klienta w potencjalnie transkodowanym żądaniu:
$userAgent = null;

// Baza danych DeviceAtlas nie zawiera właściwości urządzeń, na których podstawie można by identyfikować
// żądania transkoderów, zatem sami sprawdzamy nagłówek X-Device-User-Agent pod kątem zawierania
// zastępczego identyfikatora klienta.

// Sprawdza wartość nagłówka X-Device-User-Agent.
// Jeśli taka wartość istnieje, należy traktować ją jako identyfikator urządzenia będącego źródłem żądania.
if ($userAgent == null) {
    if (isset($_SERVER['HTTP_X_DEVICE_USER_AGENT'])) {
        // Zapisuje identyfikator urządzenia źródłowego.
        $userAgent = $_SERVER['HTTP_X_DEVICE_USER_AGENT'];
    }
}

// Jeśli nie możemy odnaleźć transkodowanego identyfikatora klienta, przyjmujemy, że żądanie nie było transkodowane:
if ($userAgent == null) {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
}

// Uzyskuje wszystkie właściwości danego urządzenia zapisane w bazie danych DeviceAtlas:
$props = Mobi_Mtld_DA_Api::getProperties($tree, $userAgent);

?>
<ul>
<li>Transcoded? <?= ($reqIsTranscoded == true) ?></li>
<li>Request UA: <?= $_SERVER['HTTP_USER_AGENT'] ?></li>
<li>Device UA: <?= $userAgent ?></li>
<li>Device Model: <?= $props['model'] ?></li>
</ul>
</body>
</html>

