﻿<?php

// Definiuje niezbędne zmienne:
define("TITLE", "Informacje o urządzeniu z bazy danych DeviceAtlas");

// Dołącza plik nagłówka:
require ("../../../includes/header.php");

// Formatuje logiczną wartość parametru:
function formatBoolean($value) {
    return $value ? ("Tak") : ("Nie");
}

// Formatuje wartość tablicową parametru:
function formatArray($value) {
    $output = "[";
    join(',', $value); $output .= "]";
    return $output;
}

// Wyświetla element listy parametrów:
function writeCapability($name, $value) {
    $output = '<li>' . '<span class="capaName">' . $name . '</span>? <span
        class="capaValue">';
    if (is_array($value)) {
        formatArray($value);
    } else if (is_bool($value)) {
        formatBoolean($value);
    } else {
        $output .= $value;
    }
    $output .= '</span></li>';
    return $output;
}

// Inicjalizuje bazę danych DeviceAtlas:
include 'deviceatlas/Mobi/Mtld/DA/Api.php';
$tree = Mobi_Mtld_DA_Api::getTreeFromFile("deviceatlas/20091028.json");

// Uzyskuje nagłówek User-Agent użyty w danym żądaniu protokołu HTTP. Wartość tego nagłówka zostanie
// wykorzystana podczas wyszukiwania właściwości.
$userAgent = $_SERVER['HTTP_USER_AGENT'];

// Uzyskuje wszystkie właściwości danego urządzenia zapisane w bazie DeviceAtlas:
$props = Mobi_Mtld_DA_Api::getProperties($tree, $userAgent);

// Wyświetla zawartość nagłówka User-Agent, to, czy żądanie pochodzi z urządzenia mobilnego,
// oraz kilka innych parametrów urządzenia (przeglądarki):
?>
<p>Parametry urządzenia odczytane z bazy DeviceAtlas</p>
<ul>
<?= writeCapability("Aplikacja kliencka", $userAgent) ?>
<?= writeCapability("Nazwa marki", $props['vendor']) ?>
<?= writeCapability("Nazwa modelu", $props['model']) ?>
<?= writeCapability("Tradycyjna przeglądarka", $props['isBrowser']) ?>
<?= writeCapability("Urządzenie mobilne", $props['mobileDevice']) ?>
<?= writeCapability("Wymiary ekranu", $props['displayWidth'] . ' x ' .
    $props['displayHeight']) ?>
<?= writeCapability("Ekran dotykowy", $props['touchScreen']) ?>
<?= writeCapability("Obsługiwane języki znaczników", $props['markupSupport']) ?>
<?= writeCapability("Obsługa protokołu HTTPS", $props['https']) ?>
</ul>

<p>Kliknij tutaj, aby sprawdzić możliwości 
    <a href="4–8.php">przełącznika DeviceAtlas</a>.</p>

<?
// Dołącza plik stopki:
require ("../../../includes/footer.php");
?>

