﻿<?php
// Ten skrypt sprawdza, czy klientem jest urządzenie mobilne, i na tej podstawie przekierowuje klienta na
// tradycyjną stronę internetową lub stronę w wersji mobilnej.

// Identyfikator URI skryptu dla tradycyjnych przeglądarek internetowych:
$desktopRedirect = "/books/bmwd/04/desktop.php";

// Identyfikator URI skryptu dla mobilnych przeglądarek internetowych:
$mobileRedirect = "/books/bmwd/04/mobile.php";

// Inicjalizuje bazę danych WURFL:
require_once('./wurfl-php-1.r1/WURFL/WURFLManagerProvider.php');
$wurflConfigFile =
    "/home/webadmin/learnto.mobi/html/books/bmwd/04/wurfl/wurflconfig.xml";
$wurflManager = WURFL_WURFLManagerProvider::getWURFLManager($wurflConfigFile);

// Uzyskuje obiekt urządzenia na podstawie żądania protokołu HTTP:
$device = $wurflManager->getDeviceForHttpRequest($_SERVER);
// Czy klientem jest urządzenie mobilne?
$isMobileDevice = $device->getCapability('is_wireless_device');

// W razie zidentyfikowania w bazie WURFL kilku tradycyjnych przeglądarek internetowych i zwrócenia tablicy
// wyników należy wybrać pierwszą wartość z tej tablicy:
if (is_array($isMobileDevice)) {
    $isMobileDevice = $isMobileDevice[0];
}

// Implementuje przekierowanie 302 protokołu HTTP poprzez dodanie nagłówka odpowiedzi i wybranie wersji
// mobilnej w przypadku urządzeń mobilnych.
// To porównanie wymaga wyjaśnienia — $isMobileDevice jest łańcuchem, nie zmienną logiczną:
if ($isMobileDevice == "true") {
    header("Location: " . $mobileRedirect);
}
else {
    header("Location: " . $desktopRedirect);
}

exit;

?>

