﻿<?php
// Ten skrypt implementuje przełącznik mobilny, który kieruje żądanie przeglądarki internetowej
// do jednego z wielu miejsc (zależnie od możliwości urządzenia).

// Przeglądarki biurkowe są przekierowywane do tego identyfikatora URI:
$desktopRedirect = "/books/bmwd/11/desktop.php";

// Przeglądarki obsługujące tylko język WML są przekierowywane do tego identyfikatora URI:
$wmlRedirect = "/books/bmwd/11/legacy.wml";

// Przeglądarki urządzeń iPhone i iPod Touch są przekierowywane do tego identyfikatora URI:
$iphoneRedirect = "/books/bmwd/11/iphone.php";

// Przeglądarki urządzeń z ekranami dotykowymi są przekierowywane do tego identyfikatora URI:
$touchRedirect = "/books/bmwd/11/touch.php";

// Wszystkie pozostałe przeglądarki mobilne (w urządzeniach bez ekranów dotykowych oraz
// z obsługą języka XHTML-MP) są przekierowywane do tego identyfikatora URI:
$mobileRedirect = "/books/bmwd/11/mobile.php";

// Inicjalizacja bazy danych WURFL:
require_once('../04/wurfl-php-1.r1/WURFL/WURFLManagerProvider.php');
$wurflConfigFile =
    "/home/webadmin/learnto.mobi/html/books/bmwd/04/wurfl/wurflconfig.xml";
$wurflManager = WURFL_WURFLManagerProvider::getWURFLManager($wurflConfigFile);

// Identyfikuje urządzenie, które przysłało dane żądanie protokołu HTTP:
$device = $wurflManager->getDeviceForHttpRequest($_SERVER);

// Sprawdzamy możliwości urządzenia i przekierowujemy żądanie do pierwszej grupy, która spełnia
// przyjęte kryteria, aby ograniczyć liczbę odwołań do bazy danych.

// Obejście błędu — dla niektórych biurkowych przeglądarek zidentyfikowanych w bazie danych WURFL otrzymujemy dla
// właściwości is_wireless_device całą tablicę. Należy wówczas wykorzystać tylko pierwszy element tej tablicy.
$isWireless = $device->getCapability('is_wireless_device');
if (is_array($isWireless)) {
       $isWireless = $isWireless[0];
}

// Pierwsza grupa: Czy urządzeniem klienckim jest tradycyjna, biurkowa przeglądarka?
$isDesktop = ($isWireless == "false");
if ($isDesktop) {
       header("Location: " . $desktopRedirect);
       exit;
}

// Druga grupa: Czy dane urządzenie obsługuje tylko język WML?
$preferredMarkup = $device->getCapability('preferred_markup');
$isWml = (strpos($preferredMarkup, 'wml') === 0);
if ($isWml) {
       header("Location: " . $wmlRedirect);
       exit;
}

// Trzecia grupa: Czy urządzeniem klienckim jest iPhone lub iPod Touch?
// W bazie danych WURFL wszystkie urządzenia iPhones i iPod Touch są reprezentowane przez rekordy potomne
// względem węzła z identyfikatorem apple_iphone_ver1. Wystarczy więc przejść na wyższy poziom hierarchii
// i sprawdzić identyfikator urządzenia, aby określić, czy mamy do czynienia z produktem firmy Apple.
$isAppleParent = false;
$appleParent = "apple_iphone_ver1";
$ancestor = $device;
while ($ancestor != null) {
       $isAppleParent = ($ancestor->id == $appleParent);
       if ($isAppleParent) {
              break;
       }
       // Próba przejścia na wyższy poziom z węzła najwyższego poziomu powoduje wygenerowanie wyjątku.
       try {
              $ancestor = $wurflManager->getDevice($ancestor->fallBack);
       } catch (Exception $e) {
              $ancestor = null;
       }
}
if ($isAppleParent) {
       header("Location: " . $iphoneRedirect);
       exit;
}

// Czwarta grupa: Czy dane urządzenie posiada ekran dotykowy?
$isTouchscreen = ($device->getCapability('pointing_method') == "touchscreen");
if ($isTouchscreen) {
       header("Location: " . $touchRedirect);
       exit;
}

// Piąta grupa: Jeśli żaden z wcześniejszych warunków nie został spełniony, mamy do czynienia z
// urządzeniem mobilnym bez ekranu dotykowego, za to z obsługą języka XHTML-MP:
header("Location: " . $mobileRedirect);
exit;
?>

