//
//  DefaultImage.m
//  Contacts
//
//  Created by Robert Górczyński on 09/10/16.
//  Copyright © 2016 Robert Górczyński. All rights reserved.
//

#import "DefaultImage.h"

@implementation DefaultImage

+ (UIImage *)generateDefaultImageOfSize:(CGSize)size
{
    // Utworzenie ramki.
    CGRect frame = CGRectMake(0, 0, size.width, size.height);
    
    // Pobranie kontekstu obrazu.
    UIGraphicsBeginImageContext(size);
    
    // Pobranie odwołania do kontekstu.
    CGContextRef context = UIGraphicsGetCurrentContext();
    
    // Narysowanie tła w kolorze białym, aby uniknąć domyślnego czarnego.
    CGColorRef white = [[UIColor whiteColor] CGColor];
    CGContextSetFillColorWithColor(context, white);
    CGContextFillRect(context, frame);
    
    // Narysowanie żółtego koła.
    CGColorRef yellow = [[UIColor yellowColor] CGColor];
    CGContextSetFillColorWithColor(context, yellow);
    CGContextFillEllipseInRect(context, frame);
    
    // Środek koła.
    CGFloat x = frame.origin.x + size.width / 2;
    CGFloat y = frame.origin.y + size.height / 2;
    CGPoint center = CGPointMake(x, y);
    
    // Narysowanie oczu.
    CGColorRef black = [[UIColor blackColor] CGColor];
    CGRect leftEyeRect = CGRectMake(center.x - 225, center.y - 150, 80, 80);
    CGRect rightEyeRect = CGRectMake(center.x + 125, center.y - 150, 80, 80);
    CGContextSetFillColorWithColor(context, black);
    CGContextFillEllipseInRect(context, leftEyeRect);
    CGContextFillEllipseInRect(context, rightEyeRect);
    
    // Narysowanie uśmiechu.
    CGContextSetLineWidth(context, 15.0);
    CGContextBeginPath(context);
    CGContextMoveToPoint(context, center.x - 200, center.y + 150);
    CGContextAddCurveToPoint(context,
                             center.x - 100, center.y + 250,
                             center.x + 100, center.y + 250,
                             center.x + 200, center.y + 150);
    CGContextStrokePath(context);
    
    UIImage *image = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return image;
}

@end
